# Eduintx Shop - PHP MVC Cart System

Database: eduintxshop_orders

## Setup
1. Place `public` as your web root.
2. Import `sql/eduintxshop_orders.sql` into MySQL.
3. Edit `app/Core/Config.php` DB credentials.
4. Create `public/uploads` folder writable.
5. For admin: default admin in Config uses a placeholder hash. It's recommended to create an admin row in `admins` table with a password hash:
   - Generate hash in PHP: `password_hash('yourpassword', PASSWORD_BCRYPT);`
6. Visit `/` to browse, `/admin/login` to login.

## Features included
- MVC structure
- Product variants
- Stock management (stock decremented on checkout)
- Admin panel with product & order management
- Hashed admin password support (DB)
- Optional webhook notification after order (configurable in Config.php)

