<?php
class AdminController extends BaseController {
    public function login() {
        session_start();
        if ($this->isPost()) {
            $email = $_POST['email'] ?? '';
            $pass = $_POST['password'] ?? '';
            // try DB admin table first, fallback to config
            $db = Database::getInstance();
            $stmt = $db->prepare('SELECT * FROM admins WHERE email = ? LIMIT 1');
            $stmt->execute([$email]);
            $admin = $stmt->fetch();
            if ($admin) {
                if (password_verify($pass, $admin['password_hash'])) {
                    $_SESSION['admin'] = $admin['id'];
                    header('Location: /admin/dashboard'); exit;
                }
            } else {
                // fallback to Config (one-time)
                if ($email === Config::$admin['email'] && password_verify($pass, Config::$admin['password_hash'])) {
                    // create admin in DB
                    $h = Config::$admin['password_hash'];
                    $stmt2 = $db->prepare('INSERT INTO admins (email, password_hash, name, created_at) VALUES (?,?,?,NOW())');
                    $stmt2->execute([$email, $h, 'Admin']);
                    $_SESSION['admin'] = $db->lastInsertId();
                    header('Location: /admin/dashboard'); exit;
                }
            }
            $this->view('admin/login', ['error'=>'Invalid credentials']);
            return;
        }
        $this->view('admin/login');
    }

    private function ensure() {
        session_start();
        if (empty($_SESSION['admin'])) {
            header('Location: /admin/login'); exit;
        }
    }

    public function dashboard() {
        $this->ensure();
        $orderModel = new Order();
        $orders = $orderModel->getAll(10);
        $productModel = new Product();
        $products = $productModel->all(10);
        $this->view('admin/dashboard', ['orders'=>$orders,'products'=>$products]);
    }

    public function products() {
        $this->ensure();
        $pm = new Product();
        $products = $pm->all();
        $this->view('admin/products', ['products'=>$products]);
    }

    public function productForm($id = null) {
        $this->ensure();
        $pm = new Product();
        $product = $id ? $pm->find($id) : null;
        $this->view('admin/edit_product', ['product'=>$product]);
    }

    public function saveProduct() {
        $this->ensure();
        $pm = new Product();
        $pm->save($_POST, $_FILES);
        header('Location: /admin/products'); exit;
    }

    public function orders() {
        $this->ensure();
        $orderModel = new Order();
        $orders = $orderModel->getAll();
        $this->view('admin/orders', ['orders'=>$orders]);
    }

    public function logout() {
        session_start();
        session_destroy();
        header('Location: /'); exit;
    }
}
