<?php
class Order extends Model {
    public function createOrder($data, $cart) {
        $conn = $this->db;
        $conn->beginTransaction();
        try {
            $total = 0;
            // compute total and check stock
            foreach ($cart as $c) {
                $pstmt = $conn->prepare('SELECT price, stock FROM products WHERE id = ?');
                $pstmt->execute([$c['product_id']]);
                $pinfo = $pstmt->fetch();
                $price = $pinfo['price'];
                if (!empty($c['variant_id'])) {
                    $vp = $conn->prepare('SELECT price FROM variants WHERE id=?'); $vp->execute([$c['variant_id']]); $v = $vp->fetch();
                    if($v) $price = $v['price'];
                }
                if ($pinfo && isset($pinfo['stock']) && $pinfo['stock'] < $c['qty']) {
                    throw new Exception('Out of stock for product ID '.$c['product_id']);
                }
                $total += $price * $c['qty'];
            }
            $stmt = $conn->prepare('INSERT INTO orders (name, email, phone, address, total, created_at) VALUES (?,?,?,?,?,NOW())');
            $stmt->execute([$data['name'],$data['email'],$data['phone'],$data['address'],$total]);
            $oid = $conn->lastInsertId();
            foreach ($cart as $c) {
                $pstmt = $conn->prepare('SELECT name, price FROM products WHERE id = ?');
                $pstmt->execute([$c['product_id']]);
                $pinfo = $pstmt->fetch();
                $price = $pinfo['price'];
                $variant_name = '';
                if (!empty($c['variant_id'])) {
                    $vp = $conn->prepare('SELECT name, price FROM variants WHERE id=?'); $vp->execute([$c['variant_id']]); $v = $vp->fetch();
                    if($v){ $price = $v['price']; $variant_name = $v['name']; }
                }
                $stmt2 = $conn->prepare('INSERT INTO order_items (order_id, product_id, product_name, variant, price, qty) VALUES (?,?,?,?,?,?)');
                $stmt2->execute([$oid, $c['product_id'], $pinfo['name'], $variant_name, $price, $c['qty']]);
                // reduce stock
                $conn->prepare('UPDATE products SET stock = stock - ? WHERE id = ?')->execute([$c['qty'], $c['product_id']]);
            }

            // optional webhook notification
            if (!empty(Config::$webhook['order_notification_url'])) {
                $this->notifyWebhook($oid);
            }

            $conn->commit();
            return $oid;
        } catch (Exception $e) {
            $conn->rollBack();
            throw $e;
        }
    }

    public function getAll($limit = 100) {
        $stmt = $this->db->prepare('SELECT * FROM orders ORDER BY id DESC LIMIT ?');
        $stmt->execute([$limit]);
        $orders = $stmt->fetchAll();
        foreach ($orders as &$o) {
            $stmt2 = $this->db->prepare('SELECT * FROM order_items WHERE order_id = ?');
            $stmt2->execute([$o['id']]);
            $o['items'] = $stmt2->fetchAll();
        }
        return $orders;
    }

    private function notifyWebhook($orderId) {
        $url = Config::$webhook['order_notification_url'];
        $payload = ['order_id'=>$orderId];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $res = curl_exec($ch);
        curl_close($ch);
    }
}
